/**
 * 
 */
package gov.va.med.mhv.usermgmt.util;

import gov.va.med.mhv.core.service.delegate.ServiceDelegateFactory;
import gov.va.med.mhv.core.util.Precondition;

import org.tigris.atlas.service.VoidServiceResponse;



/**
 * @author Rob Proper (Aquilent Inc.)
 *
 */
public class HelpDeskAlert implements Cloneable {

    private final String name;
    private final String subjectFormat;
    private final String messageFormat;
    private final String sender;
    private final String recipient;
    private final String replyTo;
    private String subject = null;
    private String message = null;
    
    
    public HelpDeskAlert(String name, String subjectFormat, 
        String messageFormat, String recipient) 
    {
    	this(name, subjectFormat, messageFormat, recipient, recipient, 
    		recipient);
    }

    public HelpDeskAlert(String name, String subjectFormat, 
        String messageFormat, String sender, String recipient, String replyTo) 
    {
        Precondition.assertNotBlank("name", name);
        Precondition.assertNotBlank("subjectFormat", subjectFormat);
        Precondition.assertNotBlank("messageFormat", messageFormat);
        Precondition.assertNotBlank("sender", sender);
        Precondition.assertNotBlank("recipient", recipient);
        Precondition.assertNotBlank("replyTo", replyTo);
        this.name = name;
        this.subjectFormat = subjectFormat;
        this.messageFormat = messageFormat;
        this.sender = sender;
        this.recipient = recipient;
        this.replyTo = replyTo;
    }
    
    public Object clone() {
        return new HelpDeskAlert(getName(), getSubjectFormat(), 
        	getMessageFormat(), getSender(), getRecipient(), getReplyTo());
    }
    
    public String getName() {
        return name;
    }
    
    public String getSender() {
        return sender;
    }

    public String getRecipient() {
    	return recipient;
    }

    public String getReplyTo() {
        return replyTo;
    }

    public String getSubject() {
        return subject;
    }

    public String getMessage() {
        return message;
    }

    public void formatSubject(Object... args) {
    	if (subject != null) {
    		throw new IllegalStateException("subject already set");
    	}
        subject = String.format(subjectFormat, args);
    }
    public String getSubjectFormat() {
        return subjectFormat;
    }

    public void formatMessage(Object... args) {
    	if (message != null) {
    		throw new IllegalStateException("message already set");
    	}
        message = String.format(messageFormat, args);
    }
    public String getMessageFormat() {
        return messageFormat;
    }

    public VoidServiceResponse send() {
        String subject = getSubject();
        String message = getMessage();
        Precondition.assertNotBlank("this.subject", subject);
        Precondition.assertNotBlank("this.message", message);
        return ServiceDelegateFactory.createEmailServiceDelegate().
            sendMessageWithReplyTo(getSender(), getSubject(), getMessage(), 
                getRecipient(), getReplyTo());
    }

}
